\version "2.18.0"
\language "deutsch"

\paper {
 %#(set-paper-size "a4")
  markup-system-spacing = #'((basic-distance . 2))
  %system-system-spacing = #'((basic-distance . 1))
  %system-system-spacing #'basic-distance = #1
  left-margin = 1.5\cm
  line-width = 19.4\cm
  print-page-number = false
  top-margin = 10\mm
  bottom-margin = 5\mm
  ragged-last-bottom=##f
  %system-count = #5
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Cămara Ta"
  %subtitle = "Vino din Liban, mireasă"
  composer =  "melodie tradițională"
  meter = "Andante"
  tagline=""
}

global = {
  \key f \major
  \cadenzaOn
  \autoBeamOff
  \time 4/4
  \override Staff.TimeSignature #'stencil = ##f
  %\partial 4
  \set Staff.midiInstrument = "clarinet"
}

sopWords = \lyricmode {
  Că -- ma -- ra Ta, Mân -- tu -- i -- to -- rul meu, __
  o văd îm -- po -- do -- bi -- tă,
  și îm -- bră -- că -- min -- te nu am, __
  ca să in -- tru în -- tr-în -- sa.
  Lu -- mi -- nea -- ză-mi hai -- na
  su -- fle -- tu -- lui meu, 
  dă -- tă -- to -- ru -- le de lu -- mi -- nă,
  și mă mân -- tu -- ieș -- te.
}

bassWords = \lyricmode {
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 
  \skip 1 \skip 1 \skip 1 \skip 1 
  și mă mân -- tu -- ieș -- te.
 
}

sopMusic = \relative c' {
  f4 a^\accent g f f e f g( a8[ g]) f4( e)
  d4.( f8 e4 d c2) \breathe \bar "|" \break
  c4 c'^\accent b a8([ b a g]) f4 g( a8[ g] f4 e) f2 \breathe
  f4 e f g a( g) \bar "|" \break
  f e d4.( f8 e4 d c2) \breathe
  f4 f g8([ a b c]) a([ b a g]) f4 g( a8[ g] f4 e) \bar "|" \break
  f2 \breathe 
  f4 g a b c2 a d4^\accent c b a g2 \breathe
  f4 f b8([ c] b4) a g a \bar "|" \break
  b8([ c]) b4^\accent( c) c2 \breathe
  c4^\accent b a8([ b a g]) f4 g( a8[ g] f4 e) f2. b4\rest
  \bar "|."
}

altMusic = \relative c' {
  f4 a g f f e f e4( f8[ e]) d4( e) d4.( f8 e4 d c2)
  c4 a' g f8([ g f e]) d4 e( f8[ e] d4 e) f2
  f4 e f g f( g) f e d4.( f8 e4 d c2)
  f4 f e8([ f g a]) f([ g f e]) f4 e1 f2
  d4 e f g a2 f b4 a g f e2
  f4 f g8([ a] g4) f g f g8([ a]) g2 f
  f4 f f8([ g f e]) f4 g( f8[ g] f4 e) f2. b4\rest
  %f4 f f8([ g f e]) f4 g( f8[ g] f4 g) a2. b4\rest

}

tenorMusic = \relative c {
  f4 f g f f g a b4( c8[ b]) a4( g) f2( a4 b c2)
  c4 c b a8([ b a g]) f4 c'1 a2
  a4 g a b c( b) a g f4.( a8 g4 f e2)
  f4 f f2 f f4 g( a8[ b] c4 b) a2
  a4 b c dis f2 c g4 f f f c2
  f4 f g8([ f] e4) f4 e f g8([ a]) b4( c) a2
  d,4\rest d4\rest f8 f f4 f \skip1 f2. d4\rest  
  %d,4\rest d4\rest f8 f f4 f e4( f8[ g] a4 b) c2. d,4\rest
}

bassMusic = \relative c {
  f4 f c d d d d c2 d4( e) f2( a4 b c2)
  c4 a g f8([ g f e]) d4 c2( b4 c) f,2
  f'4 e d c c2 d4 c b2( g4 b c2)
  f4 f f2 f f4 c1 <f f,>2
  f4 e d dis dis4( f) c2 g4 a b c c2
  %f4 g f g a2 f f4 f e f c2
  c4 c c2 c4 c c c b4( c) f2
  d4\rest d4\rest f8 f f4 f c1 f,2. d'4\rest  
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
     \new Voice { \global \voiceOne \sopMusic }
     \new Voice { \global \voiceTwo \altMusic }
     \addlyrics { \sopWords }
    >>
        
    \new Staff <<
     \clef bass
     \new Voice { \global \voiceOne \tenorMusic }
     \new Voice { \global \voiceTwo \bassMusic }
     \addlyrics { \bassWords }
     %\new Lyrics \lyricsto "split" { a -- şa, a -- şa şi pre pă -- mânt. }
     
    >>
    >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
    \tempo 4 = 40
    \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \myScore
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}
